/*
 * Decompiled with CFR 0.152.
 */
package com.min01.archaeology.blockentity;

import com.min01.archaeology.block.BrushableBlock;
import com.min01.archaeology.init.ArchaeologyBlockEntityType;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;

public class BrushableBlockEntity
extends BlockEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String LOOT_TABLE_TAG = "LootTable";
    private static final String LOOT_TABLE_SEED_TAG = "LootTableSeed";
    private static final String HIT_DIRECTION_TAG = "hit_direction";
    private static final String ITEM_TAG = "item";
    private static final int BRUSH_COOLDOWN_TICKS = 10;
    private static final int BRUSH_RESET_TICKS = 40;
    private static final int REQUIRED_BRUSHES_TO_BREAK = 10;
    private int brushCount;
    private long brushCountResetsAtTick;
    private long coolDownEndsAtTick;
    private ItemStack item = ItemStack.f_41583_;
    @Nullable
    private Direction hitDirection;
    @Nullable
    private ResourceLocation lootTable;
    private long lootTableSeed;

    public BrushableBlockEntity(BlockPos p_277558_, BlockState p_278093_) {
        super((BlockEntityType)ArchaeologyBlockEntityType.BRUSHABLE_BLOCK.get(), p_277558_, p_278093_);
    }

    public boolean brush(long p_277786_, Player p_277520_, Direction p_277424_) {
        if (this.hitDirection == null) {
            this.hitDirection = p_277424_;
        }
        this.brushCountResetsAtTick = p_277786_ + 40L;
        if (p_277786_ >= this.coolDownEndsAtTick && this.f_58857_ instanceof ServerLevel) {
            this.coolDownEndsAtTick = p_277786_ + 10L;
            this.unpackLootTable(p_277520_);
            int i = this.getCompletionState();
            if (++this.brushCount >= 10) {
                this.brushingCompleted(p_277520_);
                return true;
            }
            this.f_58857_.m_186460_(this.m_58899_(), this.m_58900_().m_60734_(), 40);
            int j = this.getCompletionState();
            if (i != j) {
                BlockState blockstate = this.m_58900_();
                BlockState blockstate1 = (BlockState)blockstate.m_61124_((Property)BrushableBlock.DUSTED, (Comparable)Integer.valueOf(j));
                this.f_58857_.m_7731_(this.m_58899_(), blockstate1, 3);
            }
            return false;
        }
        return false;
    }

    public void unpackLootTable(Player p_277940_) {
        if (this.lootTable != null && this.f_58857_ != null && !this.f_58857_.m_5776_() && this.f_58857_.m_7654_() != null) {
            LootTable loottable = this.f_58857_.m_7654_().m_129898_().m_79217_(this.lootTable);
            if (p_277940_ instanceof ServerPlayer) {
                ServerPlayer serverplayer = (ServerPlayer)p_277940_;
                CriteriaTriggers.f_10563_.m_54597_(serverplayer, this.lootTable);
            }
            LootContext lootparams = new LootContext.Builder((ServerLevel)this.f_58857_).m_78972_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)this.f_58858_)).m_78963_(p_277940_.m_36336_()).m_78972_(LootContextParams.f_81455_, (Object)p_277940_).m_78975_(LootContextParamSets.f_81411_);
            ObjectArrayList objectarraylist = loottable.m_230922_(lootparams);
            this.item = switch (objectarraylist.size()) {
                case 0 -> ItemStack.f_41583_;
                case 1 -> (ItemStack)objectarraylist.get(0);
                default -> {
                    LOGGER.warn("Expected max 1 loot from loot table " + this.lootTable + " got " + objectarraylist.size());
                    yield (ItemStack)objectarraylist.get(0);
                }
            };
            this.lootTable = null;
            this.m_6596_();
        }
    }

    private void brushingCompleted(Player p_277549_) {
        if (this.f_58857_ != null && this.f_58857_.m_7654_() != null) {
            Block block1;
            this.dropContent(p_277549_);
            BlockState blockstate = this.m_58900_();
            this.f_58857_.m_46796_(3008, this.m_58899_(), Block.m_49956_((BlockState)blockstate));
            Block block = this.m_58900_().m_60734_();
            if (block instanceof BrushableBlock) {
                BrushableBlock brushableblock = (BrushableBlock)block;
                block1 = brushableblock.getTurnsInto();
            } else {
                block1 = Blocks.f_50016_;
            }
            this.f_58857_.m_7731_(this.f_58858_, block1.m_49966_(), 3);
        }
    }

    private void dropContent(Player p_278006_) {
        if (this.f_58857_ != null && this.f_58857_.m_7654_() != null) {
            this.unpackLootTable(p_278006_);
            if (!this.item.m_41619_()) {
                double d0 = EntityType.f_20461_.m_20678_();
                double d1 = 1.0 - d0;
                double d2 = d0 / 2.0;
                Direction direction = Objects.requireNonNullElse(this.hitDirection, Direction.UP);
                BlockPos blockpos = this.f_58858_.m_5484_(direction, 1);
                double d3 = (double)blockpos.m_123341_() + 0.5 * d1 + d2;
                double d4 = (double)blockpos.m_123342_() + 0.5 + (double)(EntityType.f_20461_.m_20679_() / 2.0f);
                double d5 = (double)blockpos.m_123343_() + 0.5 * d1 + d2;
                ItemEntity itementity = new ItemEntity(this.f_58857_, d3, d4, d5, this.item.m_41620_(this.f_58857_.f_46441_.m_188503_(21) + 10));
                itementity.m_20256_(Vec3.f_82478_);
                this.f_58857_.m_7967_((Entity)itementity);
                this.item = ItemStack.f_41583_;
            }
        }
    }

    public void checkReset() {
        if (this.f_58857_ != null) {
            if (this.brushCount != 0 && this.f_58857_.m_46467_() >= this.brushCountResetsAtTick) {
                int i = this.getCompletionState();
                this.brushCount = Math.max(0, this.brushCount - 2);
                int j = this.getCompletionState();
                if (i != j) {
                    this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)BrushableBlock.DUSTED, (Comparable)Integer.valueOf(j)), 3);
                }
                int k = 4;
                this.brushCountResetsAtTick = this.f_58857_.m_46467_() + 4L;
            }
            if (this.brushCount == 0) {
                this.hitDirection = null;
                this.brushCountResetsAtTick = 0L;
                this.coolDownEndsAtTick = 0L;
            } else {
                this.f_58857_.m_186460_(this.m_58899_(), this.m_58900_().m_60734_(), (int)(this.brushCountResetsAtTick - this.f_58857_.m_46467_()));
            }
        }
    }

    private boolean tryLoadLootTable(CompoundTag p_277740_) {
        if (p_277740_.m_128425_(LOOT_TABLE_TAG, 8)) {
            this.lootTable = new ResourceLocation(p_277740_.m_128461_(LOOT_TABLE_TAG));
            this.lootTableSeed = p_277740_.m_128454_(LOOT_TABLE_SEED_TAG);
            return true;
        }
        return false;
    }

    private boolean trySaveLootTable(CompoundTag p_277591_) {
        if (this.lootTable == null) {
            return false;
        }
        p_277591_.m_128359_(LOOT_TABLE_TAG, this.lootTable.toString());
        if (this.lootTableSeed != 0L) {
            p_277591_.m_128356_(LOOT_TABLE_SEED_TAG, this.lootTableSeed);
        }
        return true;
    }

    public CompoundTag m_5995_() {
        CompoundTag compoundtag = super.m_5995_();
        if (this.hitDirection != null) {
            compoundtag.m_128405_(HIT_DIRECTION_TAG, this.hitDirection.ordinal());
        }
        compoundtag.m_128365_(ITEM_TAG, (Tag)this.item.m_41739_(new CompoundTag()));
        return compoundtag;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void m_142466_(CompoundTag p_277597_) {
        if (!this.tryLoadLootTable(p_277597_) && p_277597_.m_128441_(ITEM_TAG)) {
            this.item = ItemStack.m_41712_((CompoundTag)p_277597_.m_128469_(ITEM_TAG));
        }
        if (p_277597_.m_128441_(HIT_DIRECTION_TAG)) {
            this.hitDirection = Direction.values()[p_277597_.m_128451_(HIT_DIRECTION_TAG)];
        }
    }

    protected void m_183515_(CompoundTag p_277339_) {
        if (!this.trySaveLootTable(p_277339_)) {
            p_277339_.m_128365_(ITEM_TAG, (Tag)this.item.m_41739_(new CompoundTag()));
        }
    }

    public void setLootTable(ResourceLocation p_277611_, long p_277991_) {
        this.lootTable = p_277611_;
        this.lootTableSeed = p_277991_;
    }

    private int getCompletionState() {
        if (this.brushCount == 0) {
            return 0;
        }
        if (this.brushCount < 3) {
            return 1;
        }
        return this.brushCount < 6 ? 2 : 3;
    }

    @Nullable
    public Direction getHitDirection() {
        return this.hitDirection;
    }

    public ItemStack getItem() {
        return this.item;
    }
}

